/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launcher.gui.config;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import pro.gravit.launcher.base.events.request.GetAvailabilityAuthRequestEvent;
import pro.gravit.launcher.base.profiles.ClientProfile;
import pro.gravit.launcher.base.request.auth.AuthRequest;
import pro.gravit.launcher.core.LauncherNetworkAPI;
import pro.gravit.launcher.gui.config.GuiModuleConfig;
import pro.gravit.launcher.gui.service.JavaService;
import pro.gravit.launcher.gui.utils.SystemTheme;
import pro.gravit.launcher.runtime.client.DirBridge;
import pro.gravit.launcher.runtime.client.UserSettings;
import pro.gravit.utils.helper.JavaHelper;

public class RuntimeSettings
extends UserSettings {
    public static final LAUNCHER_LOCALE DEFAULT_LOCALE = LAUNCHER_LOCALE.UKRAINIAN;
    public transient Path updatesDir;
    @LauncherNetworkAPI
    public String login;
    @LauncherNetworkAPI
    public AuthRequest.AuthPasswordInterface password;
    @LauncherNetworkAPI
    public boolean autoAuth;
    @LauncherNetworkAPI
    public GetAvailabilityAuthRequestEvent.AuthAvailability lastAuth;
    @LauncherNetworkAPI
    public String updatesDirPath;
    @LauncherNetworkAPI
    public UUID lastProfile;
    @LauncherNetworkAPI
    public volatile LAUNCHER_LOCALE locale;
    @LauncherNetworkAPI
    public String oauthAccessToken;
    @LauncherNetworkAPI
    public String oauthRefreshToken;
    @LauncherNetworkAPI
    public long oauthExpire;
    @LauncherNetworkAPI
    public volatile LAUNCHER_THEME theme = LAUNCHER_THEME.COMMON;
    @LauncherNetworkAPI
    public Map<UUID, ProfileSettings> profileSettings = new HashMap<UUID, ProfileSettings>();
    @LauncherNetworkAPI
    public List<ClientProfile> profiles;
    @LauncherNetworkAPI
    public GlobalSettings globalSettings = new GlobalSettings();

    public static RuntimeSettings getDefault(GuiModuleConfig config) {
        RuntimeSettings runtimeSettings = new RuntimeSettings();
        runtimeSettings.autoAuth = false;
        runtimeSettings.updatesDir = DirBridge.defaultUpdatesDir;
        runtimeSettings.locale = config.locale == null ? LAUNCHER_LOCALE.UKRAINIAN : LAUNCHER_LOCALE.valueOf(config.locale);
        try {
            runtimeSettings.theme = SystemTheme.getSystemTheme();
        }
        catch (Throwable e) {
            runtimeSettings.theme = LAUNCHER_THEME.COMMON;
        }
        return runtimeSettings;
    }

    public void apply() {
        if (this.updatesDirPath != null) {
            this.updatesDir = Paths.get(this.updatesDirPath, new String[0]);
        }
    }

    public static enum LAUNCHER_THEME {
        COMMON(null, "default"),
        DARK("dark", "dark"),
        OLD("old", "old");

        public final String name;
        public final String displayName;

        private LAUNCHER_THEME(String name, String displayName) {
            this.name = name;
            this.displayName = displayName;
        }
    }

    public static class GlobalSettings {
        @LauncherNetworkAPI
        public boolean prismVSync = true;
        @LauncherNetworkAPI
        public boolean debugAllClients = false;
    }

    public static enum LAUNCHER_LOCALE {
        BELARUSIAN("be", "\u0411\u0435\u043b\u0430\u0440\u0443\u0441\u043a\u0430\u044f"),
        UKRAINIAN("uk", "\u0423\u043a\u0440\u0430\u0457\u043d\u0441\u044c\u043a\u0430"),
        POLISH("pl", "Polska"),
        ENGLISH("en", "English");

        public final String name;
        public final String displayName;

        private LAUNCHER_LOCALE(String name, String displayName) {
            this.name = name;
            this.displayName = displayName;
        }
    }

    public static class ProfileSettingsView {
        private final transient ProfileSettings settings;
        public int ram;
        public boolean debug;
        public boolean fullScreen;
        public boolean autoEnter;
        public String javaPath;
        public boolean waylandSupport;
        public boolean debugSkipUpdate;
        public boolean debugSkipFileMonitor;

        public ProfileSettingsView(ProfileSettings settings) {
            this.ram = settings.ram;
            this.debug = settings.debug;
            this.fullScreen = settings.fullScreen;
            this.autoEnter = settings.autoEnter;
            this.javaPath = settings.javaPath;
            this.waylandSupport = settings.waylandSupport;
            this.debugSkipUpdate = settings.debugSkipUpdate;
            this.debugSkipFileMonitor = settings.debugSkipFileMonitor;
            this.settings = settings;
        }

        public void apply() {
            this.settings.ram = this.ram;
            this.settings.debug = this.debug;
            this.settings.autoEnter = this.autoEnter;
            this.settings.fullScreen = this.fullScreen;
            this.settings.javaPath = this.javaPath;
            this.settings.waylandSupport = this.waylandSupport;
            this.settings.debugSkipUpdate = this.debugSkipUpdate;
            this.settings.debugSkipFileMonitor = this.debugSkipFileMonitor;
        }
    }

    public static class ProfileSettings {
        @LauncherNetworkAPI
        public int ram;
        @LauncherNetworkAPI
        public boolean debug;
        @LauncherNetworkAPI
        public boolean fullScreen;
        @LauncherNetworkAPI
        public boolean autoEnter;
        @LauncherNetworkAPI
        public String javaPath;
        @LauncherNetworkAPI
        public boolean waylandSupport;
        @LauncherNetworkAPI
        public boolean debugSkipUpdate;
        @LauncherNetworkAPI
        public boolean debugSkipFileMonitor;

        public static ProfileSettings getDefault(JavaService javaService, ClientProfile profile) {
            ProfileSettings settings = new ProfileSettings();
            ClientProfile.ProfileDefaultSettings defaultSettings = profile.getSettings();
            settings.ram = defaultSettings.ram;
            settings.autoEnter = defaultSettings.autoEnter;
            settings.fullScreen = defaultSettings.fullScreen;
            JavaHelper.JavaVersion version = javaService.getRecommendJavaVersion(profile);
            if (version != null) {
                settings.javaPath = version.jvmDir.toString();
            }
            settings.debugSkipUpdate = false;
            settings.debugSkipFileMonitor = false;
            return settings;
        }
    }
}

